package com.zhang.config;

import com.zhang.mapper.UserMapper;
import com.zhang.pojo.User;
import com.zhang.service.UserServiceImpl;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author zhangxiny
 * @apiNote
 * @date 2022-01-26 15:28
 */
public class UserRealm extends AuthorizingRealm {

    @Autowired
    UserServiceImpl userService;

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {

        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();

        Subject subject = SecurityUtils.getSubject();
        User user = (User) subject.getPrincipal();
        info.addStringPermission(user.getPerms());
        System.out.println("授权");
        return info;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        System.out.println("认证");
        //用户名、密码
        String username = "root";
        String password = "123456";

        UsernamePasswordToken userToken = (UsernamePasswordToken) token;
        User user = userService.login(userToken.getUsername());
        if (user == null) {
             return null;
        }


//        if (!userToken.getUsername().equals(username)) {
//            return null;    //抛出异常 UnknownAccountException
//        }
        //密码认证，shiro处理
        return new SimpleAuthenticationInfo(user ,user.getPwd(),"");
    }
}
